/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_NOTAS_PAINEL]    Script Date: 04/08/2014 09:57:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_NOTAS_PAINEL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_NOTAS_PAINEL]
GO


/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 241108
'Job.................:  
'Nome................: P_ATUALIZA_NOTAS_PAINEL
'Objetivo............: Procedimento utilizado para atualizar o status da nota na tabela PDV_VD_NFCE com base no XML das tabelas PDV_VD_NFCE_ARQ_DANFE e PDV_VD_NFCE_ARQ_DANFE_CANCEL
'Tabelas.............: PDV_VD_NFCE, PDV_VD_NFCE_ARQ_DANFE , PDV_VD_NFCE_ARQ_DANFE_CANCEL
'Dt Criação..........: 01/11/2024
'Dt Ult Alteracão....: 10/12/2024
'Criado por..........: Marcos Barros
'Alterado por........: Lucas Bischoff
'=======================================================================================
*/

CREATE PROCEDURE [dbo].[P_ATUALIZA_NOTAS_PAINEL]
AS
BEGIN

	DECLARE @CD_NFCE INT, @CD_DANFE INT, @CD_FILIAL INT , @CD_CX INT , @SERIE INT , @NR_NF INT , @COD_STAT INT;


    -- Lista notas que serão alteradas
    DECLARE cursorNotas CURSOR FOR
    WITH XMLNAMESPACES ('http://www.w3.org/2003/05/soap-envelope' AS env,
						'http://www.portalfiscal.inf.br/nfe/wsdl/NFeInutilizacao4' AS wsd,
						'http://www.portalfiscal.inf.br/nfe' AS nfe),
	DANFE_XML AS (
				  -- Busca notas autorizadas
				  SELECT 
							 D.CD_NFCE,
							 D.CD_DANFE,
							 C.CD_FILIAL,
							 C.CD_CX,
							 C.SERIE,
							 C.NR_NF,
							 TRY_CAST(CONVERT(VARCHAR(MAX),(D.XML_DANFE)) AS XML) AS XML_NOTA
						 FROM 
							PDV_VD_NFCE_ARQ_DANFE (NOLOCK) D
							LEFT JOIN PDV_VD_PDV_VD_NFCE (NOLOCK) L ON D.CD_NFCE = L.CD_NFCE 
							LEFT JOIN PDV_VD (NOLOCK) A ON L.CD_EMP = A.CD_EMP AND L.CD_FILIAL = A.CD_FILIAL AND L.CD_VD = A.CD_VD
							LEFT JOIN PDV_VD_NFCE (NOLOCK) C ON C.CD_NFCE = L.CD_NFCE AND C.CD_FILIAL = L.CD_FILIAL
						 WHERE 
							 A.CD_EMP = 1 
							 AND A.FLAG_NFCE = 1 
							 AND (D.FLAG_TRIAGEM_NOTA = 0 )
							
							
				UNION ALL
				-- Busca notas canceladas
				SELECT 
							 DC.CD_NFCE,
							 DC.CD_DANFE,
							 C.CD_FILIAL,
							 C.CD_CX,
							 C.SERIE,
							 C.NR_NF,
							  TRY_CAST(CONVERT(VARCHAR(MAX),(DC.ARQUIVO_DANFE_CANCEL)) AS XML) AS XML_NOTA
 
						 FROM 
							PDV_VD_NFCE_ARQ_DANFE_CANCEL (NOLOCK) DC
							LEFT JOIN PDV_VD_PDV_VD_NFCE (NOLOCK) L ON DC.CD_NFCE = L.CD_NFCE
							LEFT JOIN PDV_VD (NOLOCK) A ON L.CD_EMP = A.CD_EMP AND L.CD_FILIAL = A.CD_FILIAL AND L.CD_VD = A.CD_VD
							LEFT JOIN PDV_VD_NFCE (NOLOCK) C ON C.CD_NFCE = L.CD_NFCE AND C.CD_FILIAL = L.CD_FILIAL
						 WHERE 
							 A.CD_EMP = 1 
							 AND A.FLAG_NFCE = 1 
							 AND (DC.FLAG_TRIAGEM_NOTA = 0 )
						
					 )

				SELECT  
					CD_NFCE,
					CD_DANFE,
					CD_FILIAL,
					CD_CX,
					SERIE,
					NR_NF,
					COALESCE(
						XML_NOTA.value('(/nfe:procEventoNFe/nfe:retEvento/nfe:infEvento/nfe:cStat)[1]', 'int'), 
						XML_NOTA.value('(/nfe:retConsSitNFe/nfe:procEventoNFe/nfe:retEvento/nfe:infEvento/nfe:cStat)[1]', 'int'),
						XML_NOTA.value('(/nfe:ProcInutNFe/nfe:retInutNFe/nfe:infInut/nfe:cStat)[1]', 'int'),
						XML_NOTA.value('(/nfe:procInutNFe/nfe:retInutNFe/nfe:infInut/nfe:cStat)[1]', 'int'),
						XML_NOTA.value('(//nfe:retEnvEvento/nfe:retEvento/nfe:infEvento/nfe:cStat)[1]', 'int'),
						XML_NOTA.value('(/env:Envelope/env:Body/wsd:nfeResultMsg/nfe:retInutNFe/nfe:infInut/nfe:cStat)[1]', 'int'),
						XML_NOTA.value('(/*:infEvento/*:cStat)[1]', 'int'),
						XML_NOTA.value('(/nfe:nfeProc/nfe:protNFe/nfe:infProt/nfe:cStat)[1]', 'int'),
						0  
					) AS COD_STAT
				FROM 
					DANFE_XML;

    OPEN cursorNotas;

    FETCH NEXT FROM cursorNotas INTO @CD_NFCE, @CD_DANFE, @CD_FILIAL, @CD_CX, @SERIE, @NR_NF, @COD_STAT 

    WHILE @@FETCH_STATUS = 0
    BEGIN

        -- Execução para atualizar o COD_STAT conforme xml
        UPDATE PDV_VD_NFCE   SET COD_STAT = @COD_STAT  WHERE CD_EMP = 1 AND CD_NFCE = @CD_NFCE AND CD_FILIAL = @CD_FILIAL AND CD_CX = @CD_CX AND SERIE = @SERIE AND NR_NF  = @NR_NF 
       
	    -- Altera FLAG_TRIAGEM_NOTA para processado
		UPDATE PDV_VD_NFCE_ARQ_DANFE SET FLAG_TRIAGEM_NOTA = 1 WHERE CD_NFCE = @CD_NFCE and CD_DANFE = @CD_DANFE;
		UPDATE PDV_VD_NFCE_ARQ_DANFE_CANCEL SET FLAG_TRIAGEM_NOTA = 1 WHERE CD_NFCE = @CD_NFCE and CD_DANFE = @CD_DANFE;

        -- Próximo registro
        FETCH NEXT FROM cursorNotas INTO  @CD_NFCE, @CD_DANFE, @CD_FILIAL, @CD_CX, @SERIE, @NR_NF, @COD_STAT ;
    END

    -- Fechando e desalocando o cursor
    CLOSE cursorNotas;
    DEALLOCATE cursorNotas;
END;


GO


